// $Id: CTimeToBpmPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CTimeToBpmPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CTimeToBpmPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTimeToBpmPanel, CControlPanel);

//	===========================================================================
CTimeToBpmPanel::CTimeToBpmPanel(IControlRoot *root, const long uniqueId, const CRect &area)
		       : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
			   , m_bpmFromTimeLengthEditBox(NULL)
			   , m_bpmFromTimeBeatsEditBox(NULL)
			   , m_bpmFromTimeOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CTimeToBpmPanel);

	this->onDrawDrawThePanelBounds(false);

	const long top    = 9;
	const long width  = 74;
	const long height = 20;

	m_bpmFromTimeLengthEditBox		= new CTextEdit(this,  e_bpmFromTimeLengthEditBox,	      CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "8.00", this);
	m_bpmFromTimeBeatsEditBox		= new CTextEdit(this,  e_bpmFromTimeBeatsEditBox,		  CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "4",    this);
	m_bpmFromTimeOutputValueLabel	= new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);
	
	// Reference
	m_bpmFromTimeLengthEditBox->referenced();
	m_bpmFromTimeBeatsEditBox->referenced();
	m_bpmFromTimeOutputValueLabel->referenced();

	// Set the format
	m_bpmFromTimeLengthEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_bpmFromTimeBeatsEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_bpmFromTimeOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_bpmFromTimeLengthEditBox->setAlignment(CTextEdit::e_center);
	m_bpmFromTimeBeatsEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_bpmFromTimeLengthEditBox->setSingleClickEditable();
	m_bpmFromTimeBeatsEditBox->setSingleClickEditable();

	// Colours
	m_bpmFromTimeLengthEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_bpmFromTimeBeatsEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_bpmFromTimeOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add
	this->addControl(m_bpmFromTimeLengthEditBox); 
	this->addControl(m_bpmFromTimeBeatsEditBox);
	this->addControl(m_bpmFromTimeOutputValueLabel);

	// Compute
	this->computeBpmFromTime();
}

//	===========================================================================
CTimeToBpmPanel::~CTimeToBpmPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CTimeToBpmPanel);
	FORGET_COUNTED_OBJECT(m_bpmFromTimeLengthEditBox);
	FORGET_COUNTED_OBJECT(m_bpmFromTimeBeatsEditBox);
	FORGET_COUNTED_OBJECT(m_bpmFromTimeOutputValueLabel);
}

//	===========================================================================
void CTimeToBpmPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_bpmFromTimeLengthEditBox:
		case e_bpmFromTimeBeatsEditBox:
			this->computeBpmFromTime();
		break;
	}
}

//	===========================================================================
void CTimeToBpmPanel::computeBpmFromTime()
{
	double timeInSecs = CString::toDouble(m_bpmFromTimeLengthEditBox->getString().getString());
	
	if (timeInSecs <= 0.0)
	{
		CDialog::notifyUser("Time in seconds range error!\n\n0.0 < time in seconds\n\nTime in seconds must be greater than 0", "SCal error", true);
		timeInSecs = 8.0;
		m_bpmFromTimeLengthEditBox->setText("8.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", timeInSecs);
		m_bpmFromTimeLengthEditBox->setText(string);
	}
	m_bpmFromTimeLengthEditBox->update();
	
	// Now check the number of beats
	long beats = CString::toLong(m_bpmFromTimeBeatsEditBox->getString().getString());
	
	if (beats <= 0)
	{
		CDialog::notifyUser("Beats range error!\n\n0 < beats\n\nBeats must be greater than 0", "SCal error", true);
		beats = 4;
		m_bpmFromTimeBeatsEditBox->setText("4");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%li", beats);
		m_bpmFromTimeBeatsEditBox->setText(string);
	}
	m_bpmFromTimeBeatsEditBox->update();

	// Store the output
	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getBpmFromTime(timeInSecs, CTimeSignature(4, 4), beats));
	m_bpmFromTimeOutputValueLabel->setText(output);
	m_bpmFromTimeOutputValueLabel->update();
}